#include <passport/infra/libs/cpp/unistat/builder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NUnistat;

Y_UNIT_TEST_SUITE(PasspUtilsUnistat) {
    Y_UNIT_TEST(absolute) {
        TString str;

        TSignalAbsolute<> sigInt("kokoko");

        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("kokoko_avvv", sigInt.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigInt);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_avvv",0]])", str);

        sigInt = 15;
        UNIT_ASSERT_VALUES_EQUAL(15, sigInt.GetValue());
        sigInt = 20;
        UNIT_ASSERT_VALUES_EQUAL(20, sigInt.GetValue());

        TSignalAbsolute<double> sigFloat("lololo", "avvv");

        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("lololo_avvv", sigFloat.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["lololo_avvv",0.0]])", str);

        sigFloat = 15.5;
        UNIT_ASSERT_VALUES_EQUAL(15.5, sigFloat.GetValue());
        sigFloat = 17.5;
        UNIT_ASSERT_VALUES_EQUAL(17.5, sigFloat.GetValue());

        {
            TBuilder builder(str);
            builder.Add(sigInt);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_avvv",20],["lololo_avvv",17.5]])", str);
    }

    Y_UNIT_TEST(absoluteBuffered) {
        TString str;
        TSignalBufferedAbsolute<> sigInt("kokoko");

        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("kokoko_avvv", sigInt.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigInt);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_avvv",0]])", str);

        sigInt += 15;
        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        sigInt += 100;
        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        sigInt.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115, sigInt.GetValue());
        sigInt.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115, sigInt.GetValue());
        sigInt += 1000;
        UNIT_ASSERT_VALUES_EQUAL(115, sigInt.GetValue());
        sigInt -= 111;
        sigInt.Flush();
        UNIT_ASSERT_VALUES_EQUAL(1004, sigInt.GetValue());

        TSignalBufferedAbsolute<double> sigFloat("lololo", "avvv");

        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("lololo_avvv", sigFloat.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["lololo_avvv",0.0]])", str);

        sigFloat += 15.5;
        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        sigFloat += 100;
        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        sigFloat.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115.5, sigFloat.GetValue());
        sigFloat.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115.5, sigFloat.GetValue());
        sigFloat += 1000;
        UNIT_ASSERT_VALUES_EQUAL(115.5, sigFloat.GetValue());
        sigFloat.Flush();
        UNIT_ASSERT_VALUES_EQUAL(1115.5, sigFloat.GetValue());

        {
            TBuilder builder(str);
            builder.Add(sigInt);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_avvv",1004],["lololo_avvv",1115.5]])", str);
    }

    Y_UNIT_TEST(diff) {
        TString str;
        TSignalDiff<> sigInt("kokoko");

        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("kokoko_dmmm", sigInt.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigInt);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_dmmm",0]])", str);

        sigInt += 15;
        UNIT_ASSERT_VALUES_EQUAL(15, sigInt.GetValue());
        sigInt += 100;
        UNIT_ASSERT_VALUES_EQUAL(115, sigInt.GetValue());

        TSignalDiff<double> sigFloat("lololo", "dhhh");

        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("lololo_dhhh", sigFloat.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["lololo_dhhh",0.0]])", str);

        sigFloat += 15.5;
        UNIT_ASSERT_VALUES_EQUAL(15.5, sigFloat.GetValue());
        sigFloat += 100;
        UNIT_ASSERT_VALUES_EQUAL(115.5, sigFloat.GetValue());

        {
            TBuilder builder(str);
            builder.Add(sigInt);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_dmmm",115],["lololo_dhhh",115.5]])", str);
    }

    Y_UNIT_TEST(diffBuffered) {
        TString str;
        TSignalBufferedDiff<> sigInt("kokoko");

        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("kokoko_dmmm", sigInt.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigInt);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_dmmm",0]])", str);

        sigInt += 15;
        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        sigInt += 100;
        UNIT_ASSERT_VALUES_EQUAL(0, sigInt.GetValue());
        sigInt.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115, sigInt.GetValue());
        sigInt.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115, sigInt.GetValue());
        sigInt += 1000;
        UNIT_ASSERT_VALUES_EQUAL(115, sigInt.GetValue());
        sigInt.Flush();
        UNIT_ASSERT_VALUES_EQUAL(1115, sigInt.GetValue());

        TSignalBufferedDiff<double> sigFloat("lololo", "dhhh");

        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        UNIT_ASSERT_VALUES_EQUAL("lololo_dhhh", sigFloat.GetName());
        {
            TBuilder builder(str);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["lololo_dhhh",0.0]])", str);

        sigFloat += 15.5;
        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        sigFloat += 100;
        UNIT_ASSERT_VALUES_EQUAL(0, sigFloat.GetValue());
        sigFloat.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115.5, sigFloat.GetValue());
        sigFloat.Flush();
        UNIT_ASSERT_VALUES_EQUAL(115.5, sigFloat.GetValue());
        sigFloat += 1000;
        UNIT_ASSERT_VALUES_EQUAL(115.5, sigFloat.GetValue());
        sigFloat.Flush();
        UNIT_ASSERT_VALUES_EQUAL(1115.5, sigFloat.GetValue());

        {
            TBuilder builder(str);
            builder.Add(sigInt);
            builder.Add(sigFloat);
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([["kokoko_dmmm",1115],["lololo_dhhh",1115.5]])", str);
    }

    Y_UNIT_TEST(histogram) {
        TString str;
        TSignalHistogram<> sig("kokoko", {100, 10, 50});

        UNIT_ASSERT_VALUES_EQUAL("kokoko_dhhh", sig.GetName());
        {
            TBuilder builder(str);
            builder.Add(sig);
        }
        UNIT_ASSERT_VALUES_EQUAL(
            R"([["kokoko_dhhh",[[0,0],[10,0],[50,0],[100,0]]]])",
            str);

        sig.AddValue(0);
        sig.AddValue(3);
        sig.AddValue(13);
        sig.Flush();
        sig.AddValue(73);
        sig.AddValue(50);

        {
            TBuilder builder(str);
            builder.Add(sig);
        }
        UNIT_ASSERT_VALUES_EQUAL(
            R"([["kokoko_dhhh",[[0,2],[10,1],[50,2],[100,0]]]])",
            str);
    }

    Y_UNIT_TEST(histogramBuffered) {
        TString str;
        TSignalHistogram<NBase::TSignalBufferedDiff<ui64>> sig("kokoko", {100, 10, 50});

        UNIT_ASSERT_VALUES_EQUAL("kokoko_dhhh", sig.GetName());
        {
            TBuilder builder(str);
            builder.Add(sig);
        }
        UNIT_ASSERT_VALUES_EQUAL(
            R"([["kokoko_dhhh",[[0,0],[10,0],[50,0],[100,0]]]])",
            str);

        sig.AddValue(0);
        sig.AddValue(3);
        sig.AddValue(13);
        sig.Flush();
        sig.AddValue(73);
        sig.AddValue(50);

        {
            TBuilder builder(str);
            builder.Add(sig);
        }
        UNIT_ASSERT_VALUES_EQUAL(
            R"([["kokoko_dhhh",[[0,2],[10,1],[50,0],[100,0]]]])",
            str);

        sig.Flush();
        {
            TBuilder builder(str);
            builder.Add(sig);
        }
        UNIT_ASSERT_VALUES_EQUAL(
            R"([["kokoko_dhhh",[[0,2],[10,1],[50,2],[100,0]]]])",
            str);
    }
}
