#pragma once

#include <util/system/types.h>

#include <atomic>

namespace NPassport::NUtils {
    template <typename T = ui64>
    struct TAtomicNum: std::atomic<T> {
        using TBase = std::atomic<T>;

        TAtomicNum()
            : TBase(0)
        {
        }

        using TBase::atomic;

        T GetValue() const {
            return TBase::load(std::memory_order_relaxed);
        }

        void StoreValue(T value) {
            return TBase::store(value, std::memory_order_relaxed);
        }

        void AddValue(T val) {
            (*this) += val;
        }

        void SubValue(T val) {
            (*this) -= val;
        }
    };

    template <>
    inline void TAtomicNum<double>::AddValue(double val) {
        // until C++20: after - use operator+=
        for (double prev = GetValue(); !TBase::compare_exchange_strong(prev, prev + val);) {
        }
    }

    template <>
    inline void TAtomicNum<double>::SubValue(double val) {
        // until C++20: after - use operator-=
        for (double prev = GetValue(); !TBase::compare_exchange_strong(prev, prev - val);) {
        }
    }
}
