#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NUtils {
    class TCrypto {
    public:
        static TString RandBytes(size_t size);

        static TString HmacSha256(const TStringBuf key, const TStringBuf data);
        static TString HmacSha1(const TStringBuf key, const TStringBuf data);
        static TString Sha256(const TStringBuf str);
        static TString Md5(const TStringBuf str);

        struct TCiphertext {
            TString Iv;
            TString Text;
            TString Tag;
        };

        // encrypt text with AES GCM, return true on success
        static bool EncryptGcm(const TStringBuf key, const TStringBuf input, TCiphertext& output, TString* err_msg = nullptr);
        static bool EncryptGcm(const TStringBuf key, const TStringBuf input, TCiphertext& output, const TStringBuf aa_data, TString* err_msg = nullptr);

        // decrypt AES GCM block (checking tag), return true on success
        static bool DecryptGcm(const TStringBuf key, const TCiphertext& input, TString& output, TString* err_msg = nullptr);
        static bool DecryptGcm(const TStringBuf key, const TCiphertext& input, TString& output, const TStringBuf aa_data, TString* err_msg = nullptr);

        // decrypt AES CBC block, return true on success
        static bool DecryptCbc(const TStringBuf key,
                               const TStringBuf iv,
                               const TStringBuf text,
                               TString& output,
                               TString* errMsg = nullptr);
    };
}
