#pragma once

#include <contrib/libs/openssl/include/openssl/evp.h>

#include <util/generic/strbuf.h>

#include <memory>
#include <vector>

namespace NPassport::NUtils {
    struct TEvpKey {
        TEvpKey()
            : Pkey(nullptr, &EVP_PKEY_free)
        {
        }

        std::unique_ptr<EVP_PKEY, decltype(&EVP_PKEY_free)> Pkey;
    };

    class TRsaPublicEvp: public TEvpKey {
    public:
        static TRsaPublicEvp FromPem(TStringBuf base64EncodedKey);

        struct TResult {
            bool IsSuccess = false;
            TStringBuf Details;

            bool operator==(const TResult& o) const noexcept { // for tests
                return IsSuccess == o.IsSuccess && Details == o.Details;
            }
        };

        TResult VerifyWithSha256(const TStringBuf data, const TStringBuf sign) const;
    };

    class TRsaPrivateEvp: public TEvpKey {
    public:
        using TControls = std::vector<std::pair<TString, TString>>;

        static TRsaPrivateEvp FromPem(TStringBuf base64EncodedKey);

        TString SignWithSha256(const TStringBuf data) const;

        TString DecryptWithModes(TStringBuf encrypted, const TControls& controls) const;
    };
}
