#pragma once

#include "rsa.h"

#include <contrib/libs/openssl/include/openssl/ossl_typ.h>
#include <contrib/libs/openssl/include/openssl/rsa.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/generic/yexception.h>

#include <functional>
#include <memory>

namespace NPassport::NUtils {
    class TSshPublicKey: TRsaPublicEvp {
    public:
        explicit TSshPublicKey(const TStringBuf formatedKey);

        enum class EMode {
            RSA,
            RSA_PSS
        };

        class TUnsupportedException: public yexception {
        };
        class TMalformedException: public yexception {
        };

        bool Verify(const TStringBuf sign, const TStringBuf rawString, EMode mode, TString& err) const;

        static TString GetSshAgentSign(const TStringBuf sign);

    private:
        struct TNums {
            using TNum = std::unique_ptr<BIGNUM, std::function<void(BIGNUM*)>>;
            TNum E;
            TNum N;
        };

        static TNums Parse(const TStringBuf formKey);
        static ui32 ReadUint32(const char* data);
        static TNums::TNum ReadBn(const char* data, unsigned long len);

        void InitKey(TNums&& nums);
    };
}
