#pragma once

#include <util/datetime/base.h>
#include <util/system/event.h>

namespace NPassport::NUtils {
    // https://habr.com/ru/post/227225/
    class TExponentialBackoff {
    public:
        TExponentialBackoff(TDuration min, TDuration max, double factor, double jitter);

        TDuration Increase();
        TDuration Decrease();

        void Sleep();
        void Interrupt();

        TDuration GetCurrentValue() const {
            return CurrentValue_;
        }

    private:
        const TDuration Min_;
        const TDuration Max_;
        const double Factor_;
        const double Jitter_;
        TDuration CurrentValue_;

        TAutoEvent Ev_;
    };
}
