#pragma once

#include "regular_task.h"

#include <util/generic/string.h>

#include <memory>

class TFile;

namespace NPassport::NUtils {
    class TFileLoader {
    public:
        using TFuncForFileBody = std::function<void(const TStringBuf, time_t)>;
        using TFuncForFileName = std::function<void(const TString&)>;

        TFileLoader(const TString& path, TFuncForFileBody func, TDuration period);
        TFileLoader(const TString& path, TFuncForFileName func, TDuration period);

    private:
        void Init(TDuration period);

        void Run();
        void RunImpl(const TFile& file, const time_t mtime);

        void RunForFileBody(const TFile& file, const time_t mtime);
        void RunForFileName(const time_t mtime);

        const TString Path_;
        const TFuncForFileBody FuncForFileBody_;
        const TFuncForFileName FuncForFileName_;
        time_t LastModified_ = 0;

        // must be last member
        std::unique_ptr<NUtils::TRegularTask> Refresher_;
    };

    TString ReadFile(const TString& path, time_t* mtime = nullptr);
    TString ReadFile(const TString& path, const TString& defaultValue, time_t* mtime = nullptr);
    void WriteFileViaTmp(const TString& path, TStringBuf body);
}
