#pragma once

#include <util/generic/string.h>

namespace NPassport::NUtils {
    class ILogger {
    public:
        enum class ELevel {
            DEBUG,
            INFO,
            WARNING,
            ERROR
        };

        virtual ~ILogger() = default;

        virtual void Log(const ELevel level, const char* format, va_list args) const = 0;
        virtual void Log(const ELevel level, TString&& str) const = 0;
        virtual void Log(TString&& str) const = 0;

        virtual void BuildPrefix(const ELevel level, IOutputStream& out) const = 0;
    };
}
