#include "registry.h"

#include "file_logger.h"

#include <util/generic/singleton.h>

namespace NPassport::NUtils {
    TLogRegistry& TLogRegistry::GetInstance() {
        return *Singleton<TLogRegistry>();
    }

    void TLogRegistry::Add(TLogRegistry::TLoggerPtr logger) {
        std::unique_lock lock(Mutex_);
        Loggers_.push_back(logger);
    }

    void TLogRegistry::Remove(TLogRegistry::TLoggerPtr logger) {
        std::unique_lock lock(Mutex_);
        Loggers_.erase(std::remove(Loggers_.begin(), Loggers_.end(), logger),
                       Loggers_.end());
    }

    void TLogRegistry::RotateLogs() {
        std::unique_lock lock(Mutex_);
        for (TLoggerPtr ptr : Loggers_) {
            ptr->Rotate();
        }
    }
}
