#pragma once

#include <mutex>
#include <vector>

namespace NPassport::NUtils {
    class TFileLogger;

    class TLogRegistry {
    public:
        // TODO: replace with weak ptr
        using TLoggerPtr = TFileLogger*;

        static TLogRegistry& GetInstance();

        void Add(TLoggerPtr logger);
        void Remove(TLoggerPtr logger);

        void RotateLogs();

    private:
        std::mutex Mutex_;
        std::vector<TLoggerPtr> Loggers_;
    };
}
