#pragma once

#include "logger.h"

class TStringStream;

namespace NPassport::NUtils {
    struct TStdLoggerSettings {
        enum class EDestination {
            Stderr,
            Stdout,
        };

        enum class EGroup {
            Common,
            DbPool,
        };

        EDestination Destination = EDestination::Stderr;
        EGroup Group = EGroup::Common;
    };

    class TStdLogger: public ILogger {
    public:
        TStdLogger(const TStdLoggerSettings& settings = {});

        void Log(const ELevel level, const char* format, va_list args) const override;
        void Log(const ELevel level, TString&& str) const override;
        void Log(TString&& str) const override;

        void BuildPrefix(const ELevel level, IOutputStream& out) const override;

    private:
        void SynLog(TStringStream&& stream) const;

    private:
        const TStdLoggerSettings Settings_;
    };
}
