#include "regular_task.h"

#include "log/global.h"

#include <util/system/thread.h>

namespace NPassport::NUtils {
    TRegularTask::TRegularTask(TFunc f, TDuration period, const TString& name)
        : Period_(period)
        , F_(f)
        , Stopping_(false)
    {
        if (TDuration() != period) {
            RefreshingThread_ = std::thread([name, this]() {
                RefreshingThread(name);
            });
        }
    }

    TRegularTask::~TRegularTask() {
        Stopping_ = true;
        Event_.Signal();
        if (RefreshingThread_.joinable()) {
            RefreshingThread_.join();
        }
    }

    void TRegularTask::RunNow() {
        Event_.Signal();
    }

    TDuration TRegularTask::GetTimeToSleep() const {
        return Period_.load(std::memory_order_relaxed);
    }

    void TRegularTask::RefreshingThread(TString name) {
        if (!name.empty()) {
            TThread::SetCurrentThreadName(name.c_str());
        }

        while (true) {
            Event_.WaitT(GetTimeToSleep());
            if (Stopping_.load(std::memory_order_relaxed)) {
                return;
            }

            try {
                F_();
            } catch (const std::exception& e) {
                TLog::Warning() << "RegularTask: failed to perform regular task in thread='"
                                << name << "': "
                                << e.what();
            }
        }
    }
}
