#pragma once

#include <util/system/spin_wait.h>

#include <memory>

namespace NPassport::NUtils {
    template <typename T>
    class TSharedState {
    public:
        using TPtr = std::shared_ptr<T>;

        TPtr Get() const {
            return std::atomic_load(&Cache_);
        }

        void Set(TPtr p) {
            Swap(std::move(p));
        }

        TPtr Swap(TPtr p) {
            auto tmp = Cache_;
            std::atomic_store(&Cache_, std::move(p));

            // Cache may be a huge object. It is very expensive to destroy it
            // Much better to perform destruction in this thread than in worker
            TSpinWait w;
            while (tmp.use_count() > 1) {
                w.Sleep();
            }

            return tmp;
        }

    private:
        TPtr Cache_;
    };
}
