#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

namespace NPassport::NUtils {
    /*
     * Some utils for formating or for manipulations not changing sense of data
     */

    TString FormatTimestamp(const TStringBuf ts);
    TString FormatTimestamp(const time_t ts);

    TString& EscapeEol(TString& src);
    TString& EscapeUnprintable(TString& src);
    TString EolToSpace(const TStringBuf src);
    TString Unquote(const TStringBuf src);

    TString TolowerCopy(const TStringBuf str);
    TString& Tolower(TString& str);
    TString ToupperCopy(const TStringBuf str);
    TString& Toupper(TString& str);

    TString RemoveSpaces(const TStringBuf str);

    TString& Trim(TString& str);
    TStringBuf& Trim(TStringBuf& str);
    TString TrimCopy(const TString& str);
}
