#include "thread_local_id.h"

namespace NPassport::NUtils {
    static const TString EMPTY_;

    // NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
    static thread_local const TString* REQUEST_ID_ = nullptr;

    void SetThreadLocalRequestId(const TString* id) {
        REQUEST_ID_ = id;
    }

    const TString& GetThreadLocalRequestId() {
        return REQUEST_ID_ ? *REQUEST_ID_ : EMPTY_;
    }

    TRequestIdGuard::TRequestIdGuard(const TString* id) {
        SetThreadLocalRequestId(id);
    }

    TRequestIdGuard::~TRequestIdGuard() {
        SetThreadLocalRequestId(nullptr);
    }
}
