#include <passport/infra/libs/cpp/utils/file.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(PasspUtilsFile) {
    Y_UNIT_TEST(readFile) {
        const TFsPath testFilePath = GetOutputPath() / "read_file_test_file";

        NFs::Remove(testFilePath);

        UNIT_ASSERT_EXCEPTION(
            ReadFile(testFilePath),
            yexception);
        UNIT_ASSERT_VALUES_EQUAL("DEFAULT", ReadFile(testFilePath, "DEFAULT"));

        TFileOutput(testFilePath).Write("");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            ReadFile(testFilePath),
            yexception,
            "file is empty");

        UNIT_ASSERT_VALUES_EQUAL("DEFAULT", ReadFile(testFilePath, "DEFAULT"));

        TFileOutput(testFilePath).Write("some text");
        UNIT_ASSERT_VALUES_EQUAL("some text", ReadFile(testFilePath));
        UNIT_ASSERT_VALUES_EQUAL("some text", ReadFile(testFilePath, "DEFAULT"));

        TInstant start = TInstant::Now();
        TFileOutput(testFilePath).Write("updated text");
        TInstant end = TInstant::Now();

        time_t timestamp;
        UNIT_ASSERT_VALUES_EQUAL("updated text", ReadFile(testFilePath, &timestamp));
        UNIT_ASSERT_LE_C(start.Seconds(), (ui64)timestamp, "start=" << start << ". timestamp=" << timestamp);
        UNIT_ASSERT_GE_C(end.Seconds(), (ui64)timestamp, "end=" << end << ". timestamp=" << timestamp);
    }

    Y_UNIT_TEST(writeFileViaTmp) {
        const TFsPath testFilePath = GetOutputPath() / "write_file_via_tmp_test_file";

        NFs::Remove(testFilePath);

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            WriteFileViaTmp(testFilePath.GetName(), ""),
            yexception,
            "File path is malformed");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            WriteFileViaTmp(testFilePath.Dirname(), ""),
            yexception,
            "Failed to move disk cache");

        UNIT_ASSERT_C(!NFs::Exists(testFilePath), "path " << testFilePath << " exist, but shouldn't");

        UNIT_ASSERT_NO_EXCEPTION(WriteFileViaTmp(testFilePath, "some data"));
        UNIT_ASSERT_VALUES_EQUAL("some data", TFileInput(testFilePath).ReadAll());

        UNIT_ASSERT_NO_EXCEPTION(WriteFileViaTmp(testFilePath, "some different data"));
        UNIT_ASSERT_VALUES_EQUAL("some different data", TFileInput(testFilePath).ReadAll());

        const TFsPath testSubDir = GetOutputPath() / "write_file_via_tmp_test_dir" / "some_file";

        NFs::RemoveRecursive(testSubDir.Dirname());

        UNIT_ASSERT_NO_EXCEPTION(WriteFileViaTmp(testSubDir, "Bob was here"));
        UNIT_ASSERT_VALUES_EQUAL("Bob was here", TFileInput(testSubDir).ReadAll());
    }
}
