#include <passport/infra/libs/cpp/utils/string/split.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(PasspUtilsSplit) {
    Y_UNIT_TEST(vector) {
        TString str = "1|3|5";
        auto vec = ToVector(str, nullptr, 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(1), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1|3|5", vec.at(0));

        vec = ToVector(str, "|", 5);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("3", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(2));

        str = "|1|354|5|";
        vec = ToVector(str, "|", 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(2));

        str = "$1$$5$";
        vec = ToVector(str, "$");
        UNIT_ASSERT_VALUES_EQUAL(size_t(2), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(1));

        str.clear();
        vec = ToVector(str, "|", 1);
        UNIT_ASSERT_VALUES_EQUAL(true, vec.empty());

        str = "1\n354|5|";
        vec = ToVector(str, "|", 2);
        UNIT_ASSERT_VALUES_EQUAL(size_t(2), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1\n354", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(1));

        str = "1\n354|5|";
        vec = ToVector(str, "|\n", 2);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(2));

        str = "";
        vec = ToVector(str, "|", 1);
        UNIT_ASSERT_VALUES_EQUAL(size_t(0), vec.size());

        str = "|354|354|354|";
        vec = ToVector(str, "|", 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(2));

        str = "1|3|5";
        vec = ToVector(str, '|', 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("3", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(2));

        str = "|1|354|5|";
        vec = ToVector(str, '|', 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(2));

        str = "$1$$5$";
        vec = ToVector(str, '$', 2);
        UNIT_ASSERT_VALUES_EQUAL(size_t(2), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(1));

        str = "$1$$5$";
        vec = ToVectorWithEmpty(str, '$', 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(5), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("1", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("", vec.at(2));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(3));
        UNIT_ASSERT_VALUES_EQUAL("", vec.at(4));

        str.clear();
        vec = ToVector(str, '|');
        UNIT_ASSERT_VALUES_EQUAL(true, vec.empty());
        vec = ToVectorWithEmpty(str, '|');
        UNIT_ASSERT_VALUES_EQUAL(true, vec.empty());

        str = "1\n354|5|";
        vec = ToVector(str, '|', 2);
        UNIT_ASSERT_VALUES_EQUAL(size_t(2), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("1\n354", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("5", vec.at(1));

        str = "";
        vec = ToVector(str, '|', 1);
        UNIT_ASSERT_VALUES_EQUAL(size_t(0), vec.size());

        str = "|354|354|354|";
        vec = ToVector(str, '|', 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(2));

        vec = NormalizeListValue(str, "|");
        UNIT_ASSERT_VALUES_EQUAL(size_t(1), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(0));

        str = "|354|354|354|";
        str[0] = 0;
        str[4] = 0;
        str[8] = 0;
        str[12] = 0;
        vec = ToVector(str, '\0', 3);
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL("354", vec.at(2));
    }

    Y_UNIT_TEST(transform) {
        TString str = "1|3|5";
        std::vector<int> vec;
        Transform(str, '|', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(1, vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL(3, vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL(5, vec.at(2));
        vec.clear();

        str = "$1$354$5$";
        Transform(str, '$', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(1, vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL(5, vec.at(2));
        vec.clear();

        str = "|1||5|";
        Transform(str, '|', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(2), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(1, vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL(5, vec.at(1));
        vec.clear();

        str = "|2|3|4|70497|";
        Transform(str, '|', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(4), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(2, vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL(3, vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL(4, vec.at(2));
        UNIT_ASSERT_VALUES_EQUAL(70497, vec.at(3));
        vec.clear();

        str.clear();
        Transform(str, '|', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(true, vec.empty());

        str = "1\n354|5|";
        Transform(str, '|', [&vec](const TStringBuf buf) {
            if (buf) {
                try {
                    vec.push_back(IntFromString<ui64, 10>(TString(buf)));
                } catch (...) {
                }
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(1), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(5, vec.at(0));
        vec.clear();

        str = "";
        Transform(str, '|', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(true, vec.empty());

        str = "|354|354|354|";
        Transform(str, '|', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(2));
        vec.clear();

        str = "|354|354|354|";
        str[0] = 0;
        str[4] = 0;
        str[8] = 0;
        str[12] = 0;
        Transform(str, '\0', [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(2));
        vec.clear();

        str = "1 , 354 ; 5 ";
        Transform(str, ";, ", [&vec](const TStringBuf buf) {
            if (buf) {
                vec.push_back(IntFromString<ui64, 10>(TString(buf)));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(3), vec.size());
        UNIT_ASSERT_VALUES_EQUAL(1, vec.at(0));
        UNIT_ASSERT_VALUES_EQUAL(354, vec.at(1));
        UNIT_ASSERT_VALUES_EQUAL(5, vec.at(2));
        vec.clear();

        str = "1,354, 5 ";
        std::vector<TString> strvec;
        Transform(str, nullptr, [&strvec](const TStringBuf buf) {
            if (buf) {
                strvec.push_back(TString(buf));
            }
        });
        UNIT_ASSERT_VALUES_EQUAL(size_t(1), strvec.size());
        UNIT_ASSERT_VALUES_EQUAL("1,354, 5 ", strvec.at(0));
    }
}
