#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/format.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(PasspUtilsCoder) {
    Y_UNIT_TEST(base64Test) {
        UNIT_ASSERT_VALUES_EQUAL("SGVsbG8sIGV2ZXJ5Ym9keSE=", BinToBase64(TString("Hello, everybody!")));
        UNIT_ASSERT_VALUES_EQUAL("Hello, everybody!", Base64ToBin(TString("SGVsbG8sIGV2ZXJ5Ym9keSE")));
        UNIT_ASSERT_VALUES_EQUAL("VGhlIE1hZ2ljIFdvcmRzIGFyZSBTcXVlYW1pc2ggT3NzaWZyYWdl",
                                 BinToBase64(TString("The Magic Words are Squeamish Ossifrage")));
        UNIT_ASSERT_VALUES_EQUAL("The Magic Words are Squeamish Ossifrage",
                                 Base64ToBin(TString("VGhlIE1hZ2ljIFdvcmRzIGFyZSBTcXVlYW1pc2ggT3NzaWZyYWdl")));

        for (ui16 c = 0; c < 256; ++c) {
            for (ui16 size = 0; size < 256; ++size) {
                TString str(size, char(c));
                UNIT_ASSERT_VALUES_EQUAL(str, Base64ToBin(BinToBase64(str, false)));
            }
        }
    }

    Y_UNIT_TEST(base64urlTest) {
        UNIT_ASSERT_VALUES_EQUAL("SGVsbG8sIGV2ZXJ5Ym9keSE=", Bin2base64url(TString("Hello, everybody!"), true));
        UNIT_ASSERT_VALUES_EQUAL("Hello, everybody!", Base64url2bin(TString("SGVsbG8sIGV2ZXJ5Ym9keSE")));
        UNIT_ASSERT_VALUES_EQUAL("VGhlIE1hZ2ljIFdvcmRzIGFyZSBTcXVlYW1pc2ggT3NzaWZyYWdl",
                                 Bin2base64url(TString("The Magic Words are Squeamish Ossifrage"), true));
        UNIT_ASSERT_VALUES_EQUAL("The Magic Words are Squeamish Ossifrage",
                                 Base64url2bin(TString("VGhlIE1hZ2ljIFdvcmRzIGFyZSBTcXVlYW1pc2ggT3NzaWZyYWdl")));

        for (ui16 c = 0; c < 256; ++c) {
            for (ui16 size = 0; size < 256; ++size) {
                TString str(size, char(c));
                UNIT_ASSERT_VALUES_EQUAL(str, Base64url2bin(Bin2base64url(str, false)));
            }
        }
    }

    Y_UNIT_TEST(base32Test) {
        for (ui16 c = 0; c < 256; ++c) {
            for (ui16 size = 0; size < 256; ++size) {
                TString str(size, char(c));
                UNIT_ASSERT_VALUES_EQUAL(str, Base32ToBin(BinToBase32(str)));
                UNIT_ASSERT_VALUES_EQUAL(str, Base32ToBin(ToupperCopy(BinToBase32(str))));
            }
        }
    }
}
