#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <library/cpp/testing/unittest/registar.h>

#include <array>

using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(StrUtils) {
    Y_UNIT_TEST(ascii) {
        std::array<char, 1> s = {0x00};
        size_t idx = 0;

        for (; idx < 128; ++idx) {
            s[0] = idx;
            UNIT_ASSERT_VALUES_EQUAL(1, Utf8CharLength(s.begin(), s.end()));
        }

        for (; idx < 256; ++idx) {
            s[0] = idx;
            UNIT_ASSERT_VALUES_EQUAL(0, Utf8CharLength(s.begin(), s.end()));
        }
    }

    Y_UNIT_TEST(utfByte2) {
        std::array<char, 2> s = {0x00, 0x00};

        for (size_t c1 = 128; c1 < 256; ++c1) {
            s[0] = c1;

            for (size_t c2 = 0; c2 < 256; ++c2) {
                s[1] = c2;
                size_t len = (c1 >= 0xC2 && c1 <= 0xDF) &&
                                     (c2 >= 0x80 && c2 <= 0xBF)
                                 ? 2
                                 : 0;
                UNIT_ASSERT_VALUES_EQUAL(len, Utf8CharLength(s.begin(), s.end()));
            }
        }
    }

    Y_UNIT_TEST(utfByte3) {
        std::array<char, 3> s = {0x00, 0x00, 0x00};

        for (size_t c1 = 0xE0; c1 < 256; ++c1) {
            s[0] = c1;

            for (size_t c2 = 0x80; c2 < 256; ++c2) {
                s[1] = c2;

                for (size_t c3 = 0; c3 < 256; ++c3) {
                    s[2] = c3;
                    size_t len = (c1 == 0xE0 &&
                                  c2 >= 0xA0 && c2 <= 0xBF &&
                                  c3 >= 0x80 && c3 <= 0xBF) ||
                                         (c1 == 0xED &&
                                          c2 >= 0x80 && c2 <= 0x9F &&
                                          c3 >= 0x80 && c3 <= 0xBF) ||
                                         ((c1 >= 0xE1 && c1 <= 0xEC || c1 == 0xEE || c1 == 0xEF) &&
                                          (c2 >= 0x80 && c2 <= 0xBF) &&
                                          (c3 >= 0x80 && c3 <= 0xBF))
                                     ? 3
                                     : 0;

                    UNIT_ASSERT_VALUES_EQUAL_C(len,
                                               Utf8CharLength(s.begin(), s.end()),
                                               Bin2hex(TStringBuf(s.data(), s.size())));
                }
            }
        }
    }

    Y_UNIT_TEST(utfByte4) {
        std::array<char, 4> s = {0x00, 0x00, 0x00, 0x00};

        for (size_t c1 = 0xF0; c1 < 256; ++c1) {
            s[0] = c1;

            for (size_t c2 = 0x80; c2 < 256; ++c2) {
                s[1] = c2;

                for (size_t c3 = 0x80; c3 < 256; ++c3) {
                    s[2] = c3;

                    for (size_t c4 = 0; c4 < 256; ++c4) {
                        s[3] = c4;

                        bool isValid = false;

                        switch (c1) {
                            case 0xF0:
                                isValid = c2 >= 0x90 && c2 <= 0xBF;
                                break;
                            case 0xF1:
                            case 0xF2:
                            case 0xF3:
                                isValid = c2 >= 0x80 && c2 <= 0xBF;
                                break;
                            case 0xF4:
                                isValid = c2 >= 0x80 && c2 <= 0x8F;
                                break;
                        }

                        size_t len = isValid &&
                                             c3 >= 0x80 && c3 <= 0xBF &&
                                             c4 >= 0x80 && c4 <= 0xBF
                                         ? 4
                                         : 0;

                        UNIT_ASSERT_VALUES_EQUAL(len, Utf8CharLength(s.begin(), s.end()));
                    }
                }
            }
        }
    }
}
