LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    contrib/libs/openssl
    library/cpp/openssl/holders
    library/cpp/openssl/init
    library/cpp/string_utils/base64
    library/cpp/string_utils/quote
)

SRCS(
    crypto/hash.cpp
    crypto/rsa.cpp
    crypto/sshkey.cpp
    exponential_backoff.cpp
    file.cpp
    ipaddr.cpp
    regular_task.cpp
    string/coder.cpp
    string/format.cpp
    string/split.cpp
    string/string_utils.cpp
    thread_local_id.cpp
)

IF (NOT OS_WINDOWS)
    SRCS(
        log/global.cpp
        log/file_logger.cpp
        log/registry.cpp
        log/std_logger.cpp
    )
ENDIF()

GENERATE_ENUM_SERIALIZATION(log/logger.h)
GENERATE_ENUM_SERIALIZATION(log/std_logger.h)

END()

RECURSE_FOR_TESTS(
    ut
    ut_medium
)

IF (NOT OS_WINDOWS)
    RECURSE_FOR_TESTS(ut_py)
ENDIF()
