#include "error_info.h"

#include <contrib/libs/libxml/include/libxml/xmlerror.h>

#include <util/stream/printf.h>
#include <util/stream/str.h>

namespace NPassport::NXml {
    void GenericHandler(void* ctx, const char* msg, ...) {
        if (!ctx) {
            return;
        }

        TStringStream& res = *(TStringStream*)ctx;

        va_list args;
        va_start(args, msg);
        Printf(res, msg, args);
        va_end(args);
    }

    void StructuredHandler(void* userData, xmlErrorPtr error) {
        if (!userData) {
            return;
        }

        TStringStream& res = *(TStringStream*)userData;

        res << "line=" << error->line;
        if (error->node && ((xmlNodePtr)error->node)->type == XML_ELEMENT_NODE) {
            res << ". node=" << (char*)((xmlNodePtr)error->node)->name;
        }
        res << ". errcode=" << error->code;
        res << ". message: " << error->message;
    }

    TErrorInfo::TErrorInfo(EType type) {
        switch (type) {
            case Generic:
                xmlSetGenericErrorFunc(&Stream_, GenericHandler);
                break;
            case Structured:
                xmlSetStructuredErrorFunc(&Stream_, StructuredHandler);
                break;
        }
    }

    TErrorInfo::~TErrorInfo() {
        xmlSetGenericErrorFunc(nullptr, nullptr);
        xmlSetStructuredErrorFunc(nullptr, nullptr);
        xmlResetLastError();
    }
}
