#include <passport/infra/libs/cpp/xml/xml_utils.h>

#include <contrib/libs/libxml/include/libxml/parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NXml;

Y_UNIT_TEST_SUITE(PasspConfigUtils) {
    Y_UNIT_TEST(utilsMisc) {
        TUtils utils;

        UNIT_ASSERT_VALUES_EQUAL(TUtils::GetLastXmlError(), "unknown xml error");

        TString document("<xml><node foo='bar'>text</node></xml>");
        std::unique_ptr<xmlDoc, decltype(&xmlFreeDoc)> doc(xmlParseMemory(document.c_str(), document.size()), xmlFreeDoc);

        xmlNodePtr node = xmlDocGetRootElement(doc.get());
        UNIT_ASSERT_VALUES_EQUAL("", TUtils::Value(node));
        UNIT_ASSERT_VALUES_EQUAL(nullptr, TUtils::AttrValue(node, "foo"));
        node = node->children;
        UNIT_ASSERT_VALUES_EQUAL("text", TUtils::Value(node));
        UNIT_ASSERT_VALUES_EQUAL("bar", TUtils::AttrValue(node, "foo"));
    }

    Y_UNIT_TEST(escape) {
        TString buf;

        UNIT_ASSERT_VALUES_EQUAL("", TUtils::Escape(""));
        UNIT_ASSERT_VALUES_EQUAL("abc", TUtils::Escape("abc"));
        UNIT_ASSERT_VALUES_EQUAL("a&lt;&gt;&amp;&quot;&apos;??????????\t\n??\r??????????????????",
                                 TUtils::Escape("a<>&\"'\x7f\x98\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f"));

        UNIT_ASSERT_VALUES_EQUAL("", TUtils::Escape("", buf));
        UNIT_ASSERT_VALUES_EQUAL("", buf);
        UNIT_ASSERT_VALUES_EQUAL("abc", TUtils::Escape("abc", buf));
        UNIT_ASSERT_VALUES_EQUAL("abc", buf);
        UNIT_ASSERT_VALUES_EQUAL("a&lt;&gt;&amp;&quot;&apos;??????????\t\n??\r??????????????????",
                                 TUtils::Escape("a<>&\"'\x7f\x98\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f", buf));
        UNIT_ASSERT_VALUES_EQUAL("a&lt;&gt;&amp;&quot;&apos;??????????\t\n??\r??????????????????", buf);

        UNIT_ASSERT_VALUES_EQUAL("", TUtils::EscapeUtf8(""));
        UNIT_ASSERT_VALUES_EQUAL("a&amp;b??\xe0\xaa\xbb\xf4\x82\x83\xbb\xf3\x85\xab\xba?\xc2\xa2", TUtils::EscapeUtf8("a&b\x01\x02\xe0\xaa\xbb\xf5\xff\xf4\x82\x83\xbb\xf3\x85\xab\xba\x7f\xc2\xa2"));

        UNIT_ASSERT_VALUES_EQUAL("", TUtils::StrictEscapeUtf8("", buf));
        UNIT_ASSERT_VALUES_EQUAL("", buf);
        UNIT_ASSERT_EXCEPTION_CONTAINS(TUtils::StrictEscapeUtf8("a&b\x01\x02\xe0\xaa\xbb\xf5\xff\xf4\x82\x83\xbb\xf3\x85\xab\xba\x7f\xc2\xa2", buf), yexception, "is not a valid UTF-8 string");
        UNIT_ASSERT_VALUES_EQUAL("a&amp;b??\xe0\xaa\xbb", buf);
        UNIT_ASSERT_VALUES_EQUAL("a&amp;b??\xe0\xaa\xbb\xf4\x82\x83\xbb\xf3\x85\xab\xba?\xc2\xa2", TUtils::StrictEscapeUtf8("a&b\x01\x02\xe0\xaa\xbb\xf4\x82\x83\xbb\xf3\x85\xab\xba\x7f\xc2\xa2", buf));
        UNIT_ASSERT_VALUES_EQUAL("a&amp;b??\xe0\xaa\xbb\xf4\x82\x83\xbb\xf3\x85\xab\xba?\xc2\xa2", buf);
    }
}
