#include "writer.h"

#include "xml_utils.h"

#include <util/generic/yexception.h>

namespace NPassport::NXml::NWriter {
    static const TString ZERO = "0";
    static const TString ONE = "1";

    TNode::TProp::TProp(const TStringBuf name, TString& buf)
        : Buf_(buf)
    {
        Buf_.push_back(' ');
        Buf_.append(name);
        Buf_.push_back('=');
        Buf_.push_back('"');
    }

    TNode::TProp::~TProp() {
        try {
            Buf_.push_back('"');
        } catch (...) {
            Y_FAIL("%s", CurrentExceptionMessage().c_str());
        }
    }

    TNode::TNode(const TStringBuf name, TString& buf)
        : Name_(name)
        , Buf_(buf)
    {
        if (name.empty()) {
            throw yexception() << "Empty xml node name";
        }

        if (!Buf_.empty() && Buf_.back() != '\n') {
            Buf_.push_back('>');
            Buf_.push_back('\n');
        }

        Buf_.push_back('<');
        Buf_.append(Name_);
    }

    TNode::~TNode() {
        try {
            if (Open_ && Buf_.back() != '\n') {
                Buf_.push_back('/');
            } else {
                Buf_.push_back('<');
                Buf_.push_back('/');
                Buf_.append(Name_);
            }
            Buf_.push_back('>');
            Buf_.push_back('\n');
        } catch (...) {
            Y_FAIL("%s", CurrentExceptionMessage().c_str());
        }
    }

    void TNode::AddProp(const TStringBuf name, const TStringBuf value) {
        TProp prop(name, Buf_);
        TUtils::EscapeUtf8(value, Buf_);
    }

    void TNode::AddProp(const TStringBuf name, bool value) {
        TProp prop(name, Buf_);
        Buf_.append(value ? ONE : ZERO);
    }

    void TNode::SetContent(const TStringBuf content) {
        Buf_.push_back('>');
        TUtils::EscapeUtf8(content, Buf_);
        Open_ = false;
    }

    void TNode::SetContent(bool content) {
        Buf_.push_back('>');
        Buf_.append(content ? ONE : ZERO);
        Open_ = false;
    }

    void TNode::SetUnescapedContent(const TStringBuf content) {
        Buf_.push_back('>');
        Buf_.append(content);
        Open_ = false;
    }

    TString SerializeHeader(size_t reserve) {
        TString res;
        res.reserve(reserve);
        res.assign(R"(<?xml version="1.0" encoding="UTF-8"?>
)");
        return res;
    }
}
