#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/stream/str.h>

namespace NPassport::NXml::NWriter {
    class TNode {
    public:
        TNode(const TStringBuf name, TString& buf);

        ~TNode();

        void AddProp(const TStringBuf name, const TStringBuf value);
        void AddProp(const TStringBuf name, const TString& value) {
            AddProp(name, TStringBuf(value));
        }

        void AddProp(const TStringBuf name, bool value);

        template <typename T>
        void AddProp(const TStringBuf name, T value) {
            static_assert(std::is_integral_v<T>, "only numerics");
            TProp prop(name, Buf_);
            TStringOutput s(Buf_);
            s << value;
        }

        void SetContent(const TString& content) {
            SetContent(TStringBuf(content));
        }
        void SetContent(const TStringBuf content);

        void SetContent(bool content);

        template <typename T>
        void SetContent(T content) {
            static_assert(std::is_integral_v<T>, "only numerics");
            Buf_.push_back('>');
            TStringOutput s(Buf_);
            s << content;
            Open_ = false;
        }

        void SetUnescapedContent(const TStringBuf content);

    private:
        class TProp {
        public:
            TProp(const TStringBuf name, TString& buf);
            ~TProp();

        private:
            TString& Buf_;
        };

    private:
        bool Open_ = true;
        TStringBuf Name_;
        TString& Buf_;
    };

    template <typename T>
    inline void AddChildNode(const TStringBuf name, const T& value, TString& buf) {
        TNode node(name, buf);
        node.SetContent(value);
    }

    inline void AddChildNode(const TStringBuf name, TString& buf) {
        TNode node(name, buf);
    }

    TString SerializeHeader(size_t reserve = 1024);
}
