#pragma once

#include <contrib/libs/libxml/include/libxml/tree.h>

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

namespace NPassport::NXml {
    class TUtils: TNonCopyable {
    public:
        TUtils();
        virtual ~TUtils();

        static TString GetLastXmlError();

        static const char* Value(xmlAttrPtr attr);
        static TString Value(xmlNodePtr node);
        static TString ValueAllContent(xmlNodePtr node);
        static const char* AttrValue(xmlNodePtr node, const char* name);

        static TString& Escape(char c, TString& buf);
        static TString& Escape(const TString& src, TString& buf);
        static TString Escape(const TString& src);
        static TString EscapeUtf8(const TStringBuf src);
        static TString& EscapeUtf8(const TStringBuf src, TString& buf);
        static TString& StrictEscapeUtf8(const TString& src, TString& buf);
    };
}
