#include <passport/infra/libs/cpp/yp_cookie_parser/yp_cookie_parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(YpCookieParserTest) {
    Y_UNIT_TEST(GetYpCookiePartTest) {
        TString value;
        UNIT_ASSERT(!TryGetYandexPermanentCookieKey("name1", "expire1.name1", value));

        TStringBuf cookie = "expire2.name2.12345#expire3.name3.12%3D34#expire4.name4.foo.bar";

        UNIT_ASSERT(TryGetYandexPermanentCookieKey("name2", cookie, value));
        UNIT_ASSERT_VALUES_EQUAL(value, "12345");

        UNIT_ASSERT(!TryGetYandexPermanentCookieKey("no_name", cookie, value));

        UNIT_ASSERT(TryGetYandexPermanentCookieKey("name3", cookie, value));
        UNIT_ASSERT_VALUES_EQUAL(value, "12=34");

        UNIT_ASSERT(TryGetYandexPermanentCookieKey("name4", cookie, value));
        UNIT_ASSERT_VALUES_EQUAL(value, "foo.bar");

        UNIT_ASSERT(!TryGetYandexPermanentCookieKey("name1", "expire1.name1.", value));
    }

    Y_UNIT_TEST(ParseYpCookieTest) {
        TStringBuf expireField, nameField, valueField;

        UNIT_ASSERT(!TryParseYpCookiePart("expire1.name1", expireField, nameField, valueField));

        UNIT_ASSERT(TryParseYpCookiePart("expire2.name2.12345", expireField, nameField, valueField));
        UNIT_ASSERT_VALUES_EQUAL(expireField, "expire2");
        UNIT_ASSERT_VALUES_EQUAL(nameField, "name2");
        UNIT_ASSERT_VALUES_EQUAL(valueField, "12345");

        UNIT_ASSERT(TryParseYpCookiePart("expire2.name2.foo.bar", expireField, nameField, valueField));
        UNIT_ASSERT_VALUES_EQUAL(expireField, "expire2");
        UNIT_ASSERT_VALUES_EQUAL(nameField, "name2");
        UNIT_ASSERT_VALUES_EQUAL(valueField, "foo.bar");

        UNIT_ASSERT(!TryParseYpCookiePart("expire2.name2.", expireField, nameField, valueField));
        UNIT_ASSERT(!TryParseYpCookiePart(".name2.value", expireField, nameField, valueField));
        UNIT_ASSERT(!TryParseYpCookiePart("..value", expireField, nameField, valueField));
        UNIT_ASSERT(!TryParseYpCookiePart("..", expireField, nameField, valueField));


        TVector<TYpCookieElem> ypCookieParsed;
        UNIT_ASSERT(TryParseYpCookie("expire1.name1.value1#expire2.name2.value2#expire3.name3.value3", ypCookieParsed));
        UNIT_ASSERT_VALUES_EQUAL(ypCookieParsed, (TVector<TYpCookieElem>{TYpCookieElem{"expire1", "name1", "value1"}, TYpCookieElem{"expire2", "name2", "value2"}, TYpCookieElem{"expire3", "name3", "value3"}}));

        UNIT_ASSERT(!TryParseYpCookie("expire1.name1.value1#expire2.name2.", ypCookieParsed));

        UNIT_ASSERT(TryParseYpCookie("expire1.name1.value1#", ypCookieParsed));
        UNIT_ASSERT_VALUES_EQUAL(ypCookieParsed, (TVector<TYpCookieElem>{TYpCookieElem{"expire1", "name1", "value1"}}));

        UNIT_ASSERT(TryParseYpCookie("expire1.name1.12%3D34", ypCookieParsed));
        UNIT_ASSERT_VALUES_EQUAL(ypCookieParsed, (TVector<TYpCookieElem>{TYpCookieElem{"expire1", "name1", "12=34"}}));

        UNIT_ASSERT_VALUES_EQUAL(SerializeYpCookie(TVector<TYpCookieElem>{TYpCookieElem{"expire1", "name1", "value1"}}), "expire1.name1.value1");
        UNIT_ASSERT_VALUES_EQUAL(SerializeYpCookie(TVector<TYpCookieElem>{TYpCookieElem{"expire1", "name1", "value1"}, TYpCookieElem{"expire2", "name2", "value2"}}), "expire1.name1.value1#expire2.name2.value2");
        UNIT_ASSERT_VALUES_EQUAL(SerializeYpCookie(TVector<TYpCookieElem>{TYpCookieElem{"expire1", "name1", "12=34"}}), "expire1.name1.12%3D34");
        UNIT_ASSERT_VALUES_EQUAL(SerializeYpCookie(TVector<TYpCookieElem>{}), "");

        TString ypCookieUpdated;
        UNIT_ASSERT(TryUpdateYpCookie(TYpCookieElem{"expireN", "name1", "valueN"}, "expire1.name1.value1#expire2.name2.value2#expire3.name3.value3", ypCookieUpdated));
        UNIT_ASSERT_VALUES_EQUAL(ypCookieUpdated, "expireN.name1.valueN#expire2.name2.value2#expire3.name3.value3");

        UNIT_ASSERT(TryUpdateYpCookie(TYpCookieElem{"expireN", "name3", "valueN"}, "expire1.name1.value1#expire2.name2.value2#expire3.name3.value3", ypCookieUpdated));
        UNIT_ASSERT_VALUES_EQUAL(ypCookieUpdated, "expire1.name1.value1#expire2.name2.value2#expireN.name3.valueN");

        UNIT_ASSERT(TryUpdateYpCookie(TYpCookieElem{"expireN", "nameN", "valueN"}, "expire1.name1.value1#expire2.name2.value2#expire3.name3.value3", ypCookieUpdated));
        UNIT_ASSERT_VALUES_EQUAL(ypCookieUpdated, "expire1.name1.value1#expire2.name2.value2#expire3.name3.value3#expireN.nameN.valueN");

        UNIT_ASSERT(!TryUpdateYpCookie(TYpCookieElem{"expireN", "nameN", "valueN"}, "expire1.name1.value1#expire2.#expire3.name3.value3", ypCookieUpdated));
    }
}
