#pragma once

#include <util/generic/string.h>

namespace NPassport::NYpCookie{
    struct TYpCookieElem {
        TString Expire;
        TString Name;
        TString Value;

        TString Serialize() const;

        inline bool operator==(const TYpCookieElem& rhs) const {
            return Expire == rhs.Expire && Name == rhs.Name && Value == rhs.Value;
        }
    };

    bool TryParseYpCookiePart(TStringBuf cookie, TStringBuf& expireField, TStringBuf& nameField, TStringBuf& valueField);
    bool TryParseYpCookie(TStringBuf ypCookie, TVector<TYpCookieElem>& ypCookieParsed);
    bool TryGetYandexPermanentCookieKey(const TStringBuf& key, TStringBuf ypCookie, TString& cookiePartValue);
    bool TryUpdateYpCookie(const TYpCookieElem& ypCookieElem, TStringBuf ypCookie, TString& ypCookieUpdated);

    TString SerializeYpCookie(const TVector<TYpCookieElem>& ypCookieParsed);
}
