#include "periodic_table.h"

#include <util/draft/date.h>

namespace NPassport::NYt {
    TPeriodicTable::TPeriodicTable(EPeriodType type, TInstant ins)
        : TPeriodicTable(type, ins.Seconds())
    {
    }

    // this is hot method: it should be fast
    TPeriodicTable::TPeriodicTable(EPeriodType type, time_t unixtime)
        : Type_(type)
    {
        switch (Type_) {
            case Day:
                Start_ = GetDateStart(unixtime);
                break;
            case Month: {
                tm dateTm{};
                localtime_r(&unixtime, &dateTm);
                dateTm.tm_isdst = -1;
                dateTm.tm_sec = 0;
                dateTm.tm_min = 0;
                dateTm.tm_hour = 0;
                dateTm.tm_mday = 1;

                Start_ = mktime(&dateTm);
                break;
            }
        }
    }

    TString TPeriodicTable::TableName() const {
        const TInstant ins = TInstant::Seconds(Start_);

        switch (Type_) {
            case Day:
                return ins.FormatLocalTime("%Y-%m-%d");
            case Month:
                return ins.FormatLocalTime("%Y-%m");
        }
    }

    TInstant TPeriodicTable::GetStart() const {
        return TInstant::Seconds(Start_);
    }

    // this is cold method: it is ok to be slow for it
    TPeriodicTable TPeriodicTable::Next() const {
        time_t nextPeriod = 0;

        switch (Type_) {
            case Day:
                nextPeriod = (++TDate(Start_)).GetStart();
                break;
            case Month:
                nextPeriod = (TDate(Start_) + 31).GetStart();
                break;
        }

        return TPeriodicTable(Type_, nextPeriod);
    }

    TPeriodicTable TPeriodicTable::Prev() const {
        return TPeriodicTable(Type_, (--TDate(Start_)).GetStart());
    }

    TInstant TPeriodicTable::GetTimeToCreate() const {
        return Prev().GetStart();
    }

    TDuration TPeriodicTable::GetPeriod() const {
        switch (Type_) {
            case Day:
                return TDuration::Days(1);
            case Month:
                return TDuration::Days(31);
        }
    }
}
