#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NPassport::NYt {
    class TPeriodicTable {
    public:
        enum EPeriodType {
            Day,
            Month,
        };

        TPeriodicTable(EPeriodType type, TInstant ins);
        TPeriodicTable(EPeriodType type, time_t unixtime);

        TString TableName() const;
        TInstant GetStart() const;

        TPeriodicTable Next() const;
        TPeriodicTable Prev() const;

        TInstant GetTimeToCreate() const;
        TDuration GetPeriod() const;

        bool operator<(const TPeriodicTable& o) const {
            Y_VERIFY(Type_ == o.Type_);
            return Start_ < o.Start_;
        }

    private:
        time_t Start_;
        EPeriodType Type_;
    };

    class TDailyTable: public TPeriodicTable {
    public:
        TDailyTable(TInstant ins)
            : TPeriodicTable(TPeriodicTable::Day, ins)
        {
        }

        TDailyTable(time_t unixtime)
            : TPeriodicTable(TPeriodicTable::Day, unixtime)
        {
        }
    };

    class TMonthlyTable: public TPeriodicTable {
    public:
        TMonthlyTable(TInstant ins)
            : TPeriodicTable(TPeriodicTable::Month, ins)
        {
        }

        TMonthlyTable(time_t unixtime)
            : TPeriodicTable(TPeriodicTable::Month, unixtime)
        {
        }
    };
}
