#pragma once

#include "periodic_table.h"
#include "yt_client.h"

#include <passport/infra/libs/cpp/utils/regular_task.h>

namespace NPassport::NYt {
    struct TTableCreatorSettings {
        TYtClient::TCreateSettings CreateSettings;
        TString TablePrefix;
        TPeriodicTable::EPeriodType PeriodType = TPeriodicTable::Day;
        TDuration CheckPeriod = TDuration::Seconds(10);
    };

    class TTableCreator: TNonCopyable {
    public:
        TTableCreator(TYtClientFactoryPtr factory,
                      const TTableCreatorSettings& settings);
        ~TTableCreator();

    protected:
        void Run();
        void Create();

        TString GetNextTableName() const;

    private:
        TYtClientFactoryPtr Factory_;
        TTableCreatorSettings Settings_;

        TPeriodicTable NextRequired_;

        // must be last member:
        std::unique_ptr<NUtils::TRegularTask> Worker_;
    };
    using TTableCreatorPtr = std::unique_ptr<TTableCreator>;
}
