#include <passport/infra/libs/cpp/yt/periodic_table.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/draft/date.h>
#include <util/system/env.h>

using namespace NPassport::NYt;

Y_UNIT_TEST_SUITE(PeriodicTable) {
    static void SetTimeZone() {
        SetEnv("TZ", "Europe/Moscow");
        tzset();
    }

    Y_UNIT_TEST(daily) {
        auto check = [](time_t now) {
            TDailyTable d(now);

            time_t start = GetDateStart(now);
            UNIT_ASSERT_VALUES_EQUAL(start, d.GetStart().Seconds());
        };

        SetTimeZone();
        time_t now = 10005000;

        TDailyTable d(now);
        UNIT_ASSERT_VALUES_EQUAL("1970-04-26", d.TableName());
        UNIT_ASSERT_VALUES_EQUAL(9925200, d.GetStart().Seconds());
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-04-25T00:00:00+03:00"),
                                 d.GetTimeToCreate());

        check(now);
        UNIT_ASSERT_VALUES_EQUAL("1970-04-27", d.Next().TableName());
        UNIT_ASSERT_VALUES_EQUAL(10011600, d.Next().GetStart().Seconds());
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-04-26T00:00:00+03:00"),
                                 d.Next().GetTimeToCreate());

        UNIT_ASSERT_VALUES_EQUAL("1970-04-25", d.Prev().TableName());
        UNIT_ASSERT_VALUES_EQUAL(9838800, d.Prev().GetStart().Seconds());
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-04-24T00:00:00+03:00"),
                                 d.Prev().GetTimeToCreate());

        now = time(nullptr);

        TDailyTable d2(now);
        UNIT_ASSERT_VALUES_EQUAL(TInstant::Seconds(now).FormatLocalTime("%Y-%m-%d"), d2.TableName());

        check(now);
    }

    Y_UNIT_TEST(monthly) {
        SetTimeZone();

        auto check = [](time_t now) {
            TDailyTable d(now);

            time_t start = GetDateStart(now);
            UNIT_ASSERT_VALUES_EQUAL(start, d.GetStart().Seconds());
        };

        SetTimeZone();
        time_t now = 10005000;

        TMonthlyTable d(now);
        UNIT_ASSERT_VALUES_EQUAL("1970-04", d.TableName());
        UNIT_ASSERT_VALUES_EQUAL(7765200, d.GetStart().Seconds());
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-03-01T00:00:00+03:00"),
                                 d.GetTimeToCreate());

        check(now);
        UNIT_ASSERT_VALUES_EQUAL("1970-05", d.Next().TableName());
        UNIT_ASSERT_VALUES_EQUAL(10357200, d.Next().GetStart().Seconds());
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-04-01T00:00:00+03:00"),
                                 d.Next().GetTimeToCreate());

        UNIT_ASSERT_VALUES_EQUAL("1970-03", d.Prev().TableName());
        UNIT_ASSERT_VALUES_EQUAL(5086800, d.Prev().GetStart().Seconds());
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-02-01T00:00:00+03:00"),
                                 d.Prev().GetTimeToCreate());

        now = time(nullptr);

        TMonthlyTable d2(now);
        UNIT_ASSERT_VALUES_EQUAL(TInstant::Seconds(now).FormatLocalTime("%Y-%m"), d2.TableName());

        check(now);
    }
}
