#include <passport/infra/libs/cpp/yt/query.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/draft/date.h>
#include <util/system/env.h>

using namespace NPassport::NYt;

Y_UNIT_TEST_SUITE(QueryConverter) {
    template <typename T = int>
    class TQueryConverterTest: public TBaseConverter<T> {
    public:
        TWriteQuery Convert(
            const TString&,
            size_t,
            size_t) const override {
            return {};
        }

        using TBaseConverter<T>::GetSpan;
    };

    Y_UNIT_TEST(common) {
        TQueryConverterTest builder;

        builder.Add(10);
        builder.Add(11);
        builder.Add(12);

        UNIT_ASSERT_VALUES_EQUAL(3, builder.size());
        UNIT_ASSERT_VALUES_EQUAL("10#11#12#", builder.DebugString());
        UNIT_ASSERT_VALUES_EQUAL(2, builder.GetSpan(0, 2).size());
        UNIT_ASSERT_VALUES_EQUAL(10, builder.GetSpan(0, 2)[0]);
        UNIT_ASSERT_VALUES_EQUAL(11, builder.GetSpan(0, 2)[1]);
    }

    Y_UNIT_TEST(mergeConv) {
        TQueryConverterTest conv1;

        conv1.Add(10);
        conv1.Add(11);
        conv1.Add(12);

        UNIT_ASSERT_VALUES_EQUAL("10#11#12#", conv1.DebugString());

        auto conv2 = std::make_unique<TQueryConverterTest<>>();
        conv2->Add(100);
        conv2->Add(101);

        UNIT_ASSERT_EQUAL(conv1.GetType(), conv2->GetType());

        conv1.Merge(std::move(conv2));
        UNIT_ASSERT_VALUES_EQUAL("10#11#12#100#101#", conv1.DebugString());
    }

    Y_UNIT_TEST(mergeRequests) {
        auto conv11 = std::make_unique<TQueryConverterTest<>>();
        conv11->Add(10);
        conv11->Add(11);
        conv11->Add(12);

        TWriteQueries<TString> reqs1;
        reqs1.ByTable.emplace("table#1", std::move(conv11));

        auto conv12 = std::make_unique<TQueryConverterTest<>>();
        conv12->Add(100);
        conv12->Add(101);

        auto conv21 = std::make_unique<TQueryConverterTest<TString>>();
        conv21->Add("kek1");
        conv21->Add("kek2");

        TWriteQueries<TString> reqs2;
        reqs2.ByTable.emplace("table#1", std::move(conv12));
        reqs2.ByTable.emplace("table#2", std::move(conv21));
        reqs2.ByTable.emplace("table#3", nullptr);

        TWriteQueries<TString> reqs;
        reqs.Merge(std::move(reqs1));
        reqs.Merge(std::move(reqs2));
        UNIT_ASSERT_VALUES_EQUAL(2, reqs.ByTable.size());

        auto it = reqs.ByTable.find("table#1");
        UNIT_ASSERT(it != reqs.ByTable.end());
        UNIT_ASSERT_VALUES_EQUAL("10#11#12#100#101#",
                                 it->second->DebugString());

        it = reqs.ByTable.find("table#2");
        UNIT_ASSERT(it != reqs.ByTable.end());
        UNIT_ASSERT_VALUES_EQUAL("kek1#kek2#",
                                 it->second->DebugString());
    }
}
