#include "yt_client.h"

#include "yt_impl.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <yt/yt/core/misc/shutdown.h>

namespace NPassport::NYt {
    TTableSchema::TTableSchema() = default;
    TTableSchema::TTableSchema(TTableSchema&&) noexcept = default;
    TTableSchema::TTableSchema(const TTableSchema&) = default;
    TTableSchema::~TTableSchema() = default;
    TTableSchema& TTableSchema::operator=(TTableSchema&&) noexcept = default;
    TTableSchema& TTableSchema::operator=(const TTableSchema&) = default;

    TWriteQuery::TWriteQuery() = default;
    TWriteQuery::TWriteQuery(TWriteQuery&&) noexcept = default;
    TWriteQuery::~TWriteQuery() = default;

    TYtClient::TYtClient() = default;

    TYtClient::TYtClient(std::unique_ptr<TYtClientImpl> impl)
        : Impl_(std::move(impl))
    {
    }

    TYtClient::TYtClient(TYtClient&&) noexcept = default;
    TYtClient::~TYtClient() = default;

    TYtClient::TCreateResult TYtClient::CreateDynamicTable(const TString& path,
                                                           const TCreateSettings& settings) {
        return Impl_->CreateTable(path, settings);
    }

    NThreading::TFuture<TYtClient::TWriteResult> TYtClient::Write(TWriteQuery request) {
        return Impl_->Write(std::move(request));
    }

    NThreading::TFuture<TYtClient::TSelectResult> TYtClient::Select(const TString& query) {
        return Impl_->Select(query);
    }

    TYtClientFactory::TYtClientFactory(const TYtSettings& settings)
        : Impl_(std::make_unique<TYtClientFactoryImpl>(settings))
    {
    }

    TYtClientFactory::~TYtClientFactory() {
        Impl_.reset();
        NYT::Shutdown();
        TLog::Debug() << "TYtClientFactory was destroyed";
    }

    TYtClient TYtClientFactory::Create() const {
        return TYtClient(std::make_unique<TYtClientImpl>(Impl_->Create()));
    }

    void TYtClientFactory::RotateLogs() {
        TYtClientFactoryImpl::RotateLogs();
    }
}
