#pragma once

#include "yt_client.h"

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <yt/yt/client/api/rpc_proxy/config.h>
#include <yt/yt/client/api/rpc_proxy/connection.h>
#include <yt/yt/core/misc/shared_range.h>

#include <vector>

namespace NPassport::NYt {
    struct TWriteSubQuery {
        TString Path;
        NYT::NTableClient::TNameTablePtr NameTable;
        NYT::NTableClient::TRowBufferPtr RowBuffer;
        NYT::TSharedRange<NYT::NTableClient::TUnversionedRow> Range;
    };

    struct TWriteQueryImpl {
        TStackVec<TWriteSubQuery, 4> Subqueries;
    };

    struct TTableSchemaImpl {
        NYT::NTableClient::TTableSchema Schema;
    };

    class TYtClientImpl {
    public:
        TYtClientImpl(NYT::NApi::IClientPtr cl, const TYtSettings& settings);

        NThreading::TFuture<TYtClient::TSelectResult> Select(const TString& query);

        NThreading::TFuture<TYtClient::TWriteResult> Write(TWriteQuery request);

        TYtClient::TCreateResult CreateTable(const TString& path,
                                             const TYtClient::TCreateSettings& settings);

    protected:
        TString Create(const TString& path,
                       const TYtClient::TCreateSettings& settings);
        TString Alter(const TString& path,
                      const TYtClient::TCreateSettings& settings);
        TString Mount(const TString& path,
                      TDuration timeout);

    private:
        NYT::NApi::IClientPtr Cl_;
        const TYtSettings Settings_;
    };

    class TYtClientFactoryImpl {
    public:
        TYtClientFactoryImpl(const TYtSettings& settings);

        TYtClientImpl Create() const;

        const TYtSettings& GetSettings() const;
        static void RotateLogs();

    private:
        void InitLogger();

        static NYT::NApi::TClientOptions CreateOptions(const TString& oauthToken);

    private:
        const NYT::NApi::TClientOptions ClientSettings_;
        TYtSettings Settings_;
        NYT::NApi::IConnectionPtr Connection_;
    };
}
