package grantnets

import (
	"net"
	"strings"
)

type ClassicNetwork net.IPNet

func LooksLikeClassicNetwork(s string) bool {
	return strings.Contains(s, "/")
}

func ParseClassicNetwork(s string) (ClassicNetwork, error) {
	_, n, err := net.ParseCIDR(s)
	if err != nil {
		return ClassicNetwork{}, err
	}

	return ClassicNetwork(*n), nil
}

func (c *ClassicNetwork) Contains(ip net.IP) bool {
	return (*net.IPNet)(c).Contains(ip)
}
