package grantnets

import (
	"net"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type Nets struct {
	Trypos  TrypoNetworks
	Classic []ClassicNetwork
	Hosts   Hosts
}

func NewNets() *Nets {
	return &Nets{
		Trypos:  make(TrypoNetworks),
		Classic: make([]ClassicNetwork, 0),
		Hosts:   make(Hosts),
	}
}

func (n *Nets) Contains(addr string) bool {
	ip := net.ParseIP(addr)
	if ip == nil {
		return false
	}

	if n.Hosts.Contains(ip) || n.Trypos.Contains(ip) {
		return true
	}

	// TODO: O(N) is too slow. Need to replace with something faster
	for idx := range n.Classic {
		if n.Classic[idx].Contains(ip) {
			return true
		}
	}

	return false
}

func (n *Nets) Add(s string) error {
	if LooksLikeTrypoNetwork(s) {
		t, err := ParseTrypoNetwork(s)
		if err != nil {
			return xerrors.Errorf("failed to parse trypo network '%s': %w", s, err)
		}

		n.Trypos.Add(t)
		return nil
	}

	if LooksLikeClassicNetwork(s) {
		c, err := ParseClassicNetwork(s)
		if err != nil {
			return xerrors.Errorf("failed to parse classic network '%s': %w", s, err)
		}

		n.Classic = append(n.Classic, c)
		return nil
	}

	h, err := ParseHost(s)
	if err != nil {
		return xerrors.Errorf("failed to parse single host '%s': %w", s, err)
	}
	n.Hosts.Add(h)

	return nil
}
