package grantnets

import (
	"encoding/binary"
	"net"

	"a.yandex-team.ru/library/go/core/xerrors"
)

// Host contains numbers to be able to be key in map
type Host struct {
	high uint64
	low  uint64
}
type Hosts map[Host]interface{}

func ParseHost(s string) (Host, error) {
	ip := net.ParseIP(s)
	if ip == nil {
		return Host{}, xerrors.Errorf("invalid IP")
	}

	return HostFromIP(ip), nil
}

func HostFromIP(ip net.IP) Host {
	ip = ip.To16()

	return Host{
		high: binary.BigEndian.Uint64(ip[0:8]),
		low:  binary.BigEndian.Uint64(ip[8:16]),
	}
}

func (h *Hosts) Add(n Host) {
	(*h)[n] = 0
}

func (h *Hosts) Contains(ip net.IP) bool {
	_, ok := (*h)[HostFromIP(ip)]
	return ok
}
