package grantnets

import (
	"encoding/binary"
	"net"
	"strconv"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type TrypoNetworks map[uint32]*TrypoNetwork

type TrypoNetwork struct {
	ID      uint32
	Network []ClassicNetwork
}

func LooksLikeTrypoNetwork(s string) bool {
	return strings.Contains(s, "@")
}

func ParseTrypoNetwork(s string) (TrypoNetwork, error) {
	subs := strings.Split(s, "@")
	if len(subs) != 2 {
		return TrypoNetwork{}, xerrors.Errorf("malformed: bad @")
	}

	id, err := strconv.ParseUint(subs[0], 16, 32)
	if err != nil {
		return TrypoNetwork{}, xerrors.Errorf("invalid project id: '%s'", subs[0])
	}

	n, err := ParseClassicNetwork(subs[1])
	if err != nil {
		return TrypoNetwork{}, err
	}

	return TrypoNetwork{
		ID:      uint32(id),
		Network: []ClassicNetwork{n},
	}, nil
}

func (t *TrypoNetworks) Contains(ip net.IP) bool {
	id := GetProjectID(ip)
	if id == nil {
		return false
	}

	n, ok := (*t)[*id]
	if !ok {
		return false
	}

	for idx := range n.Network {
		if n.Network[idx].Contains(ip) {
			return true
		}
	}

	return false
}

func (t *TrypoNetworks) Add(n TrypoNetwork) {
	prev, ok := (*t)[n.ID]
	if ok {
		for i := range n.Network {
			prev.Network = append(prev.Network, n.Network[i])
		}
	} else {
		(*t)[n.ID] = &n
	}
}

func GetProjectID(ip net.IP) *uint32 {
	if ip4 := ip.To4(); ip4 != nil {
		return nil
	}

	res := binary.BigEndian.Uint32(ip[8:12])
	return &res
}
