package tskv

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type FileConfig struct {
	Format   string
	Filename string
}

type FileLogger struct {
	cfg    FileConfig
	logger log.Logger
}

type LineToFile struct {
	*Line
	logger log.Logger
}

func NewFileLogger(cfg FileConfig) (*FileLogger, error) {
	loggerCfg := logger.Config{
		FilePath:             cfg.Filename,
		DisablePrintingLevel: true,
		DisablePrintingTime:  true,
		LogLevel:             "info",
	}
	lg, err := logger.CreateLog(loggerCfg)

	return &FileLogger{
		cfg:    cfg,
		logger: lg,
	}, err
}

func (f *FileLogger) NewLine() *LineToFile {
	return &LineToFile{
		Line:   NewTskvLine(f.cfg.Format),
		logger: f.logger,
	}
}

func (l *LineToFile) Write() {
	l.logger.Info(l.String())
}
