package yasms

import (
	"fmt"
	"regexp"
	"strings"
)

var isLetter = regexp.MustCompile(`^[a-zA-Z0-9]+$`).MatchString

func GetYaSmsTemplateTokens(template string) ([]string, error) {
	tokens := []string{}

	currentPos := 0

	for {
		// Index returns -1 if not found
		nextTokenPos := strings.Index(template[currentPos:], "{{")
		if nextTokenPos == -1 {
			break
		}
		currentPos = currentPos + nextTokenPos + 2

		closingBracePos := strings.Index(template[currentPos:], "}}")
		if closingBracePos == -1 {
			return nil, fmt.Errorf("placeholder braces are not balanced")
		}

		token := template[currentPos : currentPos+closingBracePos]

		if !isLetter(token) {
			return nil, fmt.Errorf("token name should be a valid identifier")
		}

		tokens = append(tokens, token)
		currentPos = currentPos + closingBracePos + 2
	}

	return tokens, nil
}
