package yenv

import (
	"io/ioutil"
	"os"
	"strings"
)

// Проверка существования файла.
func fileExists(filename string) (bool, error) {
	stat, err := os.Stat(filename)
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}

		return false, err
	} else if stat.IsDir() {
		return false, nil
	}

	return true, nil
}

// Получение содержимого файла. Если файла не существует, возвращается пустая строка.
func fileContents(filename string) (string, error) {
	exists, err := fileExists(filename)
	if err != nil {
		return "", err
	} else if !exists {
		return "", nil
	}

	buf, err := ioutil.ReadFile(filename)
	if err != nil {
		return "", err
	}

	return strings.TrimSpace(string(buf)), nil
}

// Получение текущего y-окружения (см. пакеты yandex-environment-*).
func yEnv(suffix string, envName string, defaultValue string) string {
	if value := os.Getenv(envName); value != "" {
		return value
	} else {
		value, _ = fileContents("/etc/yandex/environment." + suffix)
		if value == "" {
			return defaultValue
		} else {
			return value
		}
	}
}

// Получение текущего type y-окружения (production / testing / etc).
func GetYEnvType() string {
	return yEnv("type", "YENV_TYPE", "development")
}

// Получение текущего name y-окружения (localhost / intranet / stress / etc).
func GetYEnvName() string {
	return yEnv("name", "YENV_NAME", "localhost")
}
