package ytsimple

import (
	"context"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/yt/go/yson"
	"a.yandex-team.ru/yt/go/yt"
)

func SelectAll(
	ctx context.Context,
	t yt.TabletClient,
	query string,
	timeout yson.Duration,
	scaner func(reader yt.TableReader) error,
) error {
	options := &yt.SelectRowsOptions{}
	options.TimeoutOptions = &yt.TimeoutOptions{
		Timeout: timeout,
	}

	reader, err := t.SelectRows(ctx, query, options)
	if err != nil {
		return xerrors.Errorf("failed to get create reader from YT: %w", err)
	}
	defer func() { _ = reader.Close() }()

	for reader.Next() {
		if err = scaner(reader); err != nil {
			return err
		}
	}

	if err = reader.Err(); err != nil {
		return err
	}

	return nil
}

func ScanRow(reader yt.TableReader, out interface{}) error {
	if err := reader.Scan(out); err != nil {
		return xerrors.Errorf("failed to scan response from YT: %w", err)
	}

	return nil
}
