from __future__ import print_function

import logging

from passport.infra.libs.python.gammer.gammer import (
    __Gammer as _Gammer,
)


class Gammer(object):
    """
    Long lived object.

    You can get logs from 'GAMMER':
        log = logging.getLogger('GAMMER')
    """

    def __init__(self, config_file_path):
        """
        :param config_file_path: str - filepath for xml config
        """
        self._gammer = _Gammer()

        try:
            self._gammer.initialize(config_file_path)
        finally:
            self._log_buffered()

    def _log_buffered(self):
        log = logging.getLogger('GAMMER')
        _loghandles = {
            0: log.error,
            1: log.error,
            2: log.error,
            3: log.error,
            4: log.warning,
            5: log.info,
            6: log.info,
            7: log.debug,
        }
        for lvl, msg in self._gammer.get_logs():
            _loghandles[lvl](msg)

    def encrypt_aes(self, input, random, aadata):
        """
        :param input: bytes - sensetive data to be encrypted
        :param random: bytes - regually rotated bytes
        :param aadata: bytes - aditional data witch should be associated with input
        """
        iv, text, tag, gamma_id = self._gammer.encrypt_aes(
            input=input,
            random=random,
            aadata=aadata,
        )

        return {
            'iv': iv,
            'text': text,
            'tag': tag,
            'gamma_id': gamma_id,
        }

    def decrypt_aes(self, iv, text, tag, gamma_id, random, aadata):
        """
        :param iv: bytes - initial vector for crypto
        :param text: bytes - encrypted text
        :param tag: bytes - array provided by aes on encryption
        :param gamma_id: int - gamma id
        :param random: bytes - regually rotated bytes
        :param aadata: bytes - aditional data witch should be associated with input
        """
        return self._gammer.decrypt_aes(
            iv=iv,
            text=text,
            tag=tag,
            gamma_id=gamma_id,
            random=random,
            aadata=aadata,
        )
