#pragma once

#include <exception>
#include <ios>
#include <new>
#include <stdexcept>
#include <typeinfo>

#include <Python.h>

static void gammer_raise_py_error() {
    // Catch a handful of different errors here and turn them into the
    // equivalent Python errors.
    try {
        if (!PyErr_Occurred()) {
            throw;
        }

        // let the latest Python exn pass through and ignore the current one
    } catch (const std::bad_alloc& ex) {
        PyErr_SetString(PyExc_MemoryError, ex.what());
    } catch (const std::bad_cast& ex) {
        PyErr_SetString(PyExc_TypeError, ex.what());
    } catch (const std::domain_error& ex) {
        PyErr_SetString(PyExc_ValueError, ex.what());
    } catch (const std::invalid_argument& ex) {
        PyErr_SetString(PyExc_ValueError, ex.what());
    } catch (const std::ios_base::failure& ex) {
        // Unfortunately, in standard C++ we have no way of distinguishing EOF
        // from other errors here; be careful with the exception mask
        PyErr_SetString(PyExc_IOError, ex.what());
    } catch (const std::out_of_range& ex) {
        // Change out_of_range to IndexError
        PyErr_SetString(PyExc_IndexError, ex.what());
    } catch (const std::overflow_error& ex) {
        PyErr_SetString(PyExc_OverflowError, ex.what());
    } catch (const std::range_error& ex) {
        PyErr_SetString(PyExc_ArithmeticError, ex.what());
    } catch (const std::underflow_error& ex) {
        PyErr_SetString(PyExc_ArithmeticError, ex.what());
    } catch (const std::exception& ex) {
        PyErr_SetString(PyExc_RuntimeError, ex.what());
    } catch (...) {
        PyErr_SetString(PyExc_RuntimeError, "Unknown exception");
    }
}
