#pragma once

#include "logger.h"

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NGammer {
    class IKeyRing;

    class TFacade {
    public:
        TFacade();
        ~TFacade();

        void Init(const TString& configFilePath);
        std::vector<TLogMessage> ExtractLogMessagesOnStart();

        const IKeyRing& GetKeyring() const;

    private:
        std::shared_ptr<TLogger> Logger_;
        std::unique_ptr<IKeyRing> KeyRing_;
    };
}
