#pragma once

#include <passport/infra/libs/cpp/gamma_fetcher/fetcher.h>

#include <util/generic/string.h>

namespace NPassport::NGammer {
    struct TAesMessage {
        TString Iv;
        TString Text;
        TString Tag;
        ui32 GammaId = 0;
    };

    class IKeyRing {
    public:
        virtual ~IKeyRing() = default;

        virtual TAesMessage EncryptAES(TStringBuf input, TStringBuf random, TStringBuf aadata) const = 0;
        virtual TString DecryptAES(const TAesMessage& input, TStringBuf random, TStringBuf aadata) const = 0;
    };

    class TKeyRingImpl: public IKeyRing {
    public:
        TKeyRingImpl(NGammaFetcher::TFetcher::TGammas&& gammas);

        TAesMessage EncryptAES(TStringBuf input, TStringBuf random, TStringBuf aadata) const override;
        TString DecryptAES(const TAesMessage& input, TStringBuf random, TStringBuf aadata) const override;

    private:
        TString BuildEffectiveKey(ui32 gammaId, TStringBuf random) const;

    private:
        NGammaFetcher::TFetcher::TGammas Gammas_;
    };
}
