#include "logger.h"

#include <util/generic/yexception.h>
#include <util/stream/printf.h>
#include <util/stream/str.h>

namespace NPassport::NGammer {
    void TLogger::Log(const ELevel level, const char* format, va_list args) const {
        TStringStream res;
        Printf(res, format, args);

        Log(level, std::move(res.Str()));
    }

    static int CastLevel(const NUtils::ILogger::ELevel level) {
        switch (level) {
            case NUtils::ILogger::ELevel::DEBUG:
                return 7;
            case NUtils::ILogger::ELevel::INFO:
                return 6;
            case NUtils::ILogger::ELevel::WARNING:
                return 4;
            case NUtils::ILogger::ELevel::ERROR:
                return 3;
        }
    }

    void TLogger::Log(const ELevel level, TString&& str) const {
        Messages_.Enqueue(TLogMessage{
            .Level = CastLevel(level),
            .Message = std::move(str),
        });
    }

    void TLogger::Log(TString&&) const {
        ythrow yexception() << "Only log with level is allowed";
    }

    void TLogger::BuildPrefix(const ELevel, IOutputStream&) const {
    }

    std::vector<TLogMessage> TLogger::ExtractLogMessages() {
        std::vector<TLogMessage> res;
        Messages_.DequeueAll(&res);
        return res;
    }
}
