#pragma once

#include <passport/infra/libs/cpp/utils/log/logger.h>

#include <util/thread/lfqueue.h>

#include <vector>

namespace NPassport::NGammer {
    struct TLogMessage {
        int Level = 0; // syslog level: 0(Emergency) ... 7(Debug)
        TString Message;

        bool operator==(const TLogMessage& o) const {
            return Level == o.Level && Message == o.Message;
        }
    };

    class TLogger: public NUtils::ILogger {
    public:
        void Log(const ELevel level, const char* format, va_list args) const override;
        void Log(const ELevel level, TString&& str) const override;
        void Log(TString&& str) const override;

        void BuildPrefix(const ELevel level, IOutputStream& out) const override;

        std::vector<TLogMessage> ExtractLogMessages();

    private:
        mutable TLockFreeQueue<TLogMessage> Messages_;
    };
}
