#include <passport/infra/libs/python/gammer/impl/logger.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NGammer;

Y_UNIT_TEST_SUITE(Logger) {
    Y_UNIT_TEST(LogStr) {
        TLogger log;

        log.Log(NUtils::ILogger::ELevel::DEBUG, TString("some str 1"));
        log.Log(NUtils::ILogger::ELevel::ERROR, TString("some str 2"));
        log.Log(NUtils::ILogger::ELevel::INFO, TString("some str 3"));
        log.Log(NUtils::ILogger::ELevel::WARNING, TString("some str 4"));

        std::vector<TLogMessage> expected = {
            {.Level = 7, .Message = "some str 1"},
            {.Level = 3, .Message = "some str 2"},
            {.Level = 6, .Message = "some str 3"},
            {.Level = 4, .Message = "some str 4"},
        };
        UNIT_ASSERT_VALUES_EQUAL(expected, log.ExtractLogMessages());
    }

    Y_UNIT_TEST(LogPrintf) {
        TLogger log;

        auto adapter = [&](NUtils::ILogger::ELevel level, const char* format, ...) {
            va_list args;
            va_start(args, format);
            log.Log(level, format, args);
            va_end(args);
        };

        adapter(NUtils::ILogger::ELevel::DEBUG, "some str %d", 1);
        adapter(NUtils::ILogger::ELevel::ERROR, "some str %d", 2);
        adapter(NUtils::ILogger::ELevel::INFO, "some str %d", 3);
        adapter(NUtils::ILogger::ELevel::WARNING, "some str %d", 4);

        std::vector<TLogMessage> expected = {
            {.Level = 7, .Message = "some str 1"},
            {.Level = 3, .Message = "some str 2"},
            {.Level = 6, .Message = "some str 3"},
            {.Level = 4, .Message = "some str 4"},
        };
        UNIT_ASSERT_VALUES_EQUAL(expected, log.ExtractLogMessages());
    }

    Y_UNIT_TEST(LogWithoutLevel) {
        TLogger log;

        UNIT_ASSERT_EXCEPTION(log.Log("some str 1"), yexception);

        std::vector<TLogMessage> expected;
        UNIT_ASSERT_VALUES_EQUAL(expected, log.ExtractLogMessages());
    }

    Y_UNIT_TEST(LogPrefix) {
        TLogger log;
        TStringStream s;

        log.BuildPrefix(NUtils::ILogger::ELevel::ERROR, s);

        UNIT_ASSERT_VALUES_EQUAL("", s.Str());
    }
}

template <>
void Out<TLogMessage>(IOutputStream& out, const TLogMessage& value) {
    out << "level: " << value.Level << ": " << value.Message << Endl;
}
