import os

import yatest.common
from library.python.testing.recipe import declare_recipe
from passport.infra.recipes.common import log, start_daemon, stop_daemon
from passport.infra.recipes.kolmogor.common import check_started, gen_default_config, make_space, write_config

KOLMOGOR_PORT_FILE = "kolmogor.port"
KOLMOGOR_PID_FILE = "kolmogor.pid"

CONFIG_PATH = './config.json'


def start(argv):
    log('Starting kolmogor recipe')

    cfg, kolmo_url = gen_default_config()
    cfg["component"]["spaces"].append(make_space(name="badauth"))
    write_config(CONFIG_PATH, cfg)

    port = cfg["http_daemon"]["ports"][0]["port"]
    with open(KOLMOGOR_PORT_FILE, "w") as f:
        f.write(str(port))

    # launch kolmogor
    command = [
        yatest.common.build_path() + '/passport/infra/daemons/kolmogor/daemon/kolmogor',
        '-c',
        CONFIG_PATH,
    ]

    pid = start_daemon(command, os.environ.copy(), port, 600).pid
    check_started(kolmo_url)

    with open(KOLMOGOR_PID_FILE, "w") as f:
        f.write(str(pid))


def stop(argv):
    log('Terminating kolmogor recipe')

    with open(KOLMOGOR_PID_FILE) as f:
        pid = int(f.read())
        stop_daemon(pid)


if __name__ == "__main__":
    declare_recipe(start, stop)
